/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.model.PhantomModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.layers.PhantomEyesLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.monster.Phantom;

public class PhantomRenderer
extends MobRenderer<Phantom, PhantomModel<Phantom>> {
    private static final ResourceLocation PHANTOM_LOCATION = ResourceLocation.withDefaultNamespace("textures/entity/phantom.png");

    public PhantomRenderer(EntityRendererProvider.Context p_174338_) {
        super(p_174338_, new PhantomModel(p_174338_.bakeLayer(ModelLayers.PHANTOM)), 0.75f);
        this.addLayer(new PhantomEyesLayer<Phantom>(this));
    }

    @Override
    public ResourceLocation getTextureLocation(Phantom p_115679_) {
        return PHANTOM_LOCATION;
    }

    @Override
    protected void scale(Phantom p_115681_, PoseStack p_115682_, float p_115683_) {
        int $$3 = p_115681_.getPhantomSize();
        float $$4 = 1.0f + 0.15f * (float)$$3;
        p_115682_.scale($$4, $$4, $$4);
        p_115682_.translate(0.0f, 1.3125f, 0.1875f);
    }

    @Override
    protected void setupRotations(Phantom p_320470_, PoseStack p_115674_, float p_115675_, float p_115676_, float p_115677_, float p_320856_) {
        super.setupRotations(p_320470_, p_115674_, p_115675_, p_115676_, p_115677_, p_320856_);
        p_115674_.mulPose(Axis.XP.rotationDegrees(p_320470_.getXRot()));
    }
}

